(*********************************************
TMissile->TSprite

A small, pulsing missile with a limited life span.
*********************************************)

unit Missile;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes, Graphics, Controls, TurboSprite,
  Utility;

type

  TMissile = class( TSprite )
  private
    nLife: word;
    nColor: byte;
    nMaxLife: word;
  protected
  public
    InitialSpeedX, InitialSpeedY: single;
    constructor CreateMissile( MoveProc: TMoveProc; nMax: word; nColorOffset: byte );
    procedure Move; override;
    procedure Render; override;
  end;

implementation

constructor TMissile.CreateMissile( MoveProc: TMoveProc; nMax: word; nColorOffset: byte );
begin
  inherited Create( MoveProc );
  nLife := 0;
  nColor := nColorOffset;
  Speed := 5;
  nMaxLife := nMax;
  Width := 6;
  Height := 6;
  StopAtDestination := false;
end;

procedure TMissile.Move;
begin
  Inc( nLife );
  if nLife = nMaxLife then
     Dead := true;
  inherited Move;
  X := X + InitialSpeedX;
  Y := Y + InitialSpeedY;
end;

procedure TMissile.Render;
var
  n: byte;
begin
  inherited Render;
  n := Random( 16 ) + nColor;
  if (ptPhysical.X > 1) and (ptPhysical.Y > 1) and (ptPhysical.X < SpriteSurface.DIBCanvas.Width - 2) and (ptPhysical.Y < SpriteSurface.DIBCanvas.Height - 2) then
    with ptPhysical, SpriteSurface.DIBCanvas do
    begin
      Pixels[X, Y] := n;
      Pixels[X, Y - 1] := n;
      Pixels[X, Y + 1] := n;
      Pixels[X - 1, Y] := n;
      Pixels[X + 1, Y] := n;
      Pixels[X - 1, Y - 1] := n;
      Pixels[X - 1, Y + 1] := n;
      Pixels[X + 1, Y - 1] := n;
      Pixels[X + 1, Y + 1] := n;
      Pixels[X, Y - 2] := n;
      Pixels[X, Y + 2] := n;
      Pixels[X - 2, Y] := n;
      Pixels[X + 2, Y] := n;
    end;
end;

end.
